// by Ayumi-Chizuru189
// Experimental! There may be some bugs I haven't found
// feel free to use/edit for whatever you want
(function() {
"use strict";

  var _Object_is = Object.is;
  function shallowEqual(first, second) {

    if (first === second) return true;

    var l = first.length;
    if (l !== second.length) return false;

    for (var i = 0; i < l; i++) {
      if (!_Object_is(first[i], second[i])) return false;
    }

    return true;
  }

  var symPrevBitmapLoadState = Symbol("prevBitmapLoadState");
  // Sprite_Picture.prototype._osp_prevBitmapLoadState = false;
  Sprite_Picture.prototype[symPrevBitmapLoadState] = false;

  const _Sprite_Picture_update = Sprite_Picture.prototype.update;
  Sprite_Picture.prototype.update = function() {
    //// store to check for changes later
    // updateBitmap
    var pictureName = this._pictureName;

    // updateOrigin
    var oldAnchor = this.anchor;
    var originX = oldAnchor.x;
    var originY = oldAnchor.y;

    // updatePosition
    var x = this.x;
    var y = this.y;

    // updateScale
    var oldScale = this.scale;
    var scaleX = oldScale.x;
    var scaleY = oldScale.y;

    // updateTone
    var tone = this._colorTone;

    // updateOther
    var opacity   = this.opacity;
    var blendMode = this.blendMode;
    var rotation  = this.rotation;
    ////

    // call the update method
    _Sprite_Picture_update.call(this);

    const parent = this.parent;
    if (!parent) return;

    // updateBitmap
    var bitmap = this.bitmap;
    var bitmapIMG = bitmap && bitmap.baseTexture;
    var bitmapState  = !!(bitmapIMG && bitmapIMG.hasLoaded);

    var oldBitmapState = this[symPrevBitmapLoadState];
    this[symPrevBitmapLoadState] = bitmapState;

    //// cache parent if no changes happened
    var freezeParent;
    if (this.visible) {
      var anchor = this.anchor;
      var scale  = this.scale;

      freezeParent = (
        // updateBitmap
        pictureName === this._pictureName &&
        bitmapState === oldBitmapState &&

        // updateOrigin
        originX === anchor.x &&
        originY === anchor.y &&

        // updatePosition
        x === this.x &&
        y === this.y &&

        // updateScale
        scaleX === scale.x &&
        scaleY === scale.y &&

        // updateTone
        shallowEqual(tone, this._colorTone) &&

        // updateOther
        opacity   === this.opacity &&
        blendMode === this.blendMode &&
        rotation  === this.rotation
      );

      // console.log(parent.cacheAsBitmap, doCache);
      parent.cacheAsBitmap = freezeParent;
    } else {
      freezeParent = (
        pictureName === this._pictureName &&
        bitmapState === oldBitmapState
      );

      parent.cacheAsBitmap = freezeParent;
    }
    ////
  };
})();